//FileDocumentWindow class.  Implements "nice" behavior

//Conventions:
//    Global constants (declared with const) and #defines - all uppercase letters with words separated 
//        by underscores.
//        (E.G., #define MY_DEFINE 5).
//        (E.G., const int MY_CONSTANT = 5;).
//    New data types (classes, structs, typedefs, etc.) - begin with an uppercase letter followed by
//        lowercase words separated by uppercase letters.  Enumerated constants contain a prefix
//        associating them with a particular enumerated set.
//        (E.G., typedef int MyTypedef;).
//        (E.G., enum MyEnumConst {MEC_ONE, MEC_TWO};)
//    Global variables - begin with "g_" followed by lowercase words separated by underscores.
//        (E.G., int g_my_global;).
//    Argument and local variables - begin with a lowercase letter followed by
//        lowercase words separated by underscores.
//        (E.G., int my_local;).
//    Member variables - begin with "m_" followed by lowercase words separated by underscores.
//        (E.G., int m_my_member;).
//    Functions (member or global) - begin with an uppercase letter followed by lowercase words
//        separated by uppercase letters.
//        (E.G., void MyFunction(void);).


#ifndef _SGB_FILE_DOCUMENT_WINDOW_H_
#define _SGB_FILE_DOCUMENT_WINDOW_H_


//******************************************************************************************************
//**** SYSTEM HEADER FILES
//******************************************************************************************************
#include <Window.h>


//******************************************************************************************************
//**** TYPE DEFINITIONS AND CONSTANTS
//******************************************************************************************************
const int32 FDW_SAVE_AS_REQESTED = 'fdSA';


//******************************************************************************************************
//**** FUNCTION DECLARATIONS
//******************************************************************************************************
int32 SavePrompt(void* a_data);


//******************************************************************************************************
//**** CLASS DECLARATIONS
//******************************************************************************************************
class FileDocumentWindow : public BWindow
{
	public:
		//Constructor and destructor
		//For new documents, start them with the name "Untitled" "Untitled document" "Untitled 1" etc., without
		//any path specified.  This will flag the document as being truly untitled, and a Save request (as opposed
		//to Save as...) will defer to Save as... to give it a name.  Save corresponds to B_SAVE_REQUESTED, while
		//Save as... corresponds to FDW_SAVE_AS_REQESTED
		FileDocumentWindow(BRect a_frame, const char* a_filename, window_type a_type, uint32 a_flags, 
			uint32 a_workspace = B_CURRENT_WORKSPACE);
		FileDocumentWindow(BRect a_frame, const char* a_filename, window_look a_look, window_feel a_feel,
			uint32 a_flags, uint32 a_workspace = B_CURRENT_WORKSPACE);
		virtual ~FileDocumentWindow();

		//BWindow overrides
		virtual bool QuitRequested();
		virtual void MessageReceived(BMessage* a_message);
			//Note: if you catch any of the following: FDW_SAVE_AS_REQESTED, B_SAVE_REQUESTED, or B_CANCEL, you should
			//only do so for filtering purposes.  If you are acting on those requests, make sure to pass the message
			//on to FileDocumentWindow::MessageReceived().

		//Other functions
		virtual bool Save();		//Return true if the file was saved successfully
		virtual BFilePanel* GetSavePanel(BMessenger* a_messenger,entry_ref* a_location_ref);
			//Override this if you want to return a class derived from BFilePanel instead, for example if you want to
			//add views to the BFilePanel.
		virtual void SetFileName(const char* a_filename);
		void SetModifiedFlag();		//When the user closes the window or B_QUIT_REQUESTED is received, if the modified
									//flag has been set, the FileDocumentWindow will prompt the user to Save, Don't save,
									//or Cancel.  Set the modified flag any time the user makes a modification other
									//than moving or resizing the window (or other relatively insignificant changes, at
									//the programmer's discretion)
		bool IsModifiedFlagSet();

		const char* GetLeafName(const char* a_filename = NULL);
		const char* GetFileName();

		void QuitOnceSaved();

	private:
		void FDWConstructorWork(const char* a_filename);
		void CreateSavePanel();
		bool InitiateSave(BMessage* a_message);

		BFilePanel* m_save_panel;
		char* m_filename;
		bool m_quit_after_save;
		bool m_modified;
};


#endif